/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

class LoopBreakOnShutdownTest
extends ContextTestSupport {
    private static final int LOOP_COUNT = 100;

    LoopBreakOnShutdownTest() {
    }

    @Test
    void testLoopBreakOnShutdown() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        CompletableFuture future = this.template.asyncSendBody("seda:foo", (Object)0);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(future::isDone);
        this.context.stop();
        int received = mock.getReceivedCounter();
        MatcherAssert.assertThat((Object)received, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(100))));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo").startupOrder(1).loop(100).breakOnShutdown().delay(50L).to("seda:bar");
                this.from("seda:bar").startupOrder(2).shutdownRoute(ShutdownRoute.Defer).to("mock:result");
            }
        };
    }
}

