/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.StringWriter;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.log.ConsumingAppender;
import org.apache.camel.model.RouteDefinition;
import org.apache.logging.log4j.Level;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

public class LogProcessorWithProvidedLoggerTest
extends ContextTestSupport {
    private static StringWriter sw;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        sw = new StringWriter();
        ConsumingAppender.newAppender("org.apache.camel.customlogger", "customlogger", Level.TRACE, event -> sw.append(event.getLoggerName()).append(" ").append(event.getLevel().toString()).append(" ").append(event.getMessage().getFormattedMessage()));
    }

    @Test
    public void testLogProcessorWithRegistryLogger() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        MatcherAssert.assertThat((Object)sw.toString(), (Matcher)CoreMatchers.equalTo((Object)"org.apache.camel.customlogger INFO Got Bye World"));
    }

    @Test
    public void testLogProcessorWithProvidedLogger() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:bar", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        MatcherAssert.assertThat((Object)sw.toString(), (Matcher)CoreMatchers.equalTo((Object)"org.apache.camel.customlogger INFO Also got Bye World"));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getRegistry().bind("mylogger1", (Object)LoggerFactory.getLogger((String)"org.apache.camel.customlogger"));
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:foo").routeId("foo").log(LoggingLevel.INFO, "Got ${body}")).to("mock:foo");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").log(LoggingLevel.INFO, LoggerFactory.getLogger((String)"org.apache.camel.customlogger"), "Also got ${body}")).to("mock:bar");
            }
        };
    }
}

