/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class LogEipPropagateExceptionTest
extends ContextTestSupport {
    @Test
    public void testFailure() throws Exception {
        this.getMockEndpoint("mock:handleFailure").whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                throw new RuntimeException("TEST EXCEPTION");
            }
        });
        this.getMockEndpoint("mock:exceptionFailure").expectedMessageCount(1);
        this.sendBody("direct:startFailure", "Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSuccess() throws Exception {
        this.getMockEndpoint("mock:handleSuccess").whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                throw new RuntimeException("TEST EXCEPTION");
            }
        });
        this.getMockEndpoint("mock:exceptionSuccess").expectedMessageCount(1);
        this.sendBody("direct:startSuccess", "Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.from("direct:startFailure").onException(Throwable.class).to("mock:exceptionFailure")).end().to("direct:handleFailure").to("mock:resultFailure");
                ((RouteDefinition)this.from("direct:handleFailure").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).log("FAULTY log")).to("mock:handleFailure");
                ((OnExceptionDefinition)this.from("direct:startSuccess").onException(Throwable.class).to("mock:exceptionSuccess")).end().to("direct:handleSuccess").to("mock:resultSuccess");
                this.from("direct:handleSuccess").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:handleSuccess");
            }
        };
    }
}

