/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogEipMaskTest {
    protected Registry registry;

    protected CamelContext createCamelContext() throws Exception {
        this.registry = new DefaultRegistry();
        DefaultCamelContext context = new DefaultCamelContext(this.registry);
        context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        return context;
    }

    @Test
    public void testLogEipMask() throws Exception {
        CamelContext context = this.createCamelContext();
        MockEndpoint mock = (MockEndpoint)context.getEndpoint("mock:foo", MockEndpoint.class);
        mock.expectedMessageCount(1);
        context.setLogMask(Boolean.valueOf(true));
        context.start();
        context.createProducerTemplate().sendBody("direct:foo", (Object)"mask password=\"my passw0rd!\"");
        context.createProducerTemplate().sendBody("direct:noMask", (Object)"no-mask password=\"my passw0rd!\"");
        mock.assertIsSatisfied();
        context.stop();
    }

    @Test
    public void testCustomFormatter() throws Exception {
        CamelContext context = this.createCamelContext();
        MockMaskingFormatter customFormatter = new MockMaskingFormatter();
        this.registry.bind("CamelCustomLogMask", (Object)customFormatter);
        context.setLogMask(Boolean.valueOf(true));
        context.start();
        context.createProducerTemplate().sendBody("direct:foo", (Object)"mock password=\"my passw0rd!\"");
        Assertions.assertEquals((Object)"Got mock password=\"my passw0rd!\"", (Object)customFormatter.received);
        context.stop();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:foo").routeId("foo").log("Got ${body}")).to("mock:foo");
                ((RouteDefinition)this.from("direct:noMask").routeId("noMask").logMask("false").log("Got ${body}")).to("mock:noMask");
            }
        };
    }

    public static class MockMaskingFormatter
    implements MaskingFormatter {
        private String received;

        public String format(String source) {
            this.received = source;
            return source;
        }
    }
}

