/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogEipListenerTest {
    private static boolean listenerFired;

    @Test
    public void testLogListener() throws Exception {
        listenerFired = false;
        CamelContext context = this.createCamelContext();
        MockEndpoint mock = (MockEndpoint)context.getEndpoint("mock:foo", MockEndpoint.class);
        mock.expectedMessageCount(1);
        context.getCamelContextExtension().addLogListener((exchange, camelLogger, message) -> {
            Assertions.assertEquals((Object)"Got hello", (Object)message);
            listenerFired = true;
            return message + " - modified by listener";
        });
        context.start();
        context.createProducerTemplate().sendBody("direct:foo", (Object)"hello");
        mock.assertIsSatisfied();
        Assertions.assertTrue((boolean)listenerFired);
        context.stop();
    }

    protected CamelContext createCamelContext() throws Exception {
        DefaultRegistry registry = new DefaultRegistry();
        DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
        context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:foo").routeId("foo").log("Got ${body}")).to("mock:foo");
            }
        };
    }
}

