/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.LineNumberAware;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class LineNumberProcessorTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.setSourceLocationEnabled(Boolean.valueOf(true));
        return context;
    }

    @Test
    public void testLineNumber() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"LineNumberProcessorTest.java:51"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        };
    }

    private static class MyProcessor
    implements Processor,
    LineNumberAware {
        private int lineNumber;
        private String location;

        private MyProcessor() {
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public void process(Exchange exchange) {
            exchange.getMessage().setBody((Object)(this.location + ":" + this.lineNumber));
        }
    }
}

