/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.LineNumberAware;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LineNumberProcessorDebuggingTest {
    @Test
    public void testLineNumber() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.setDebugging(Boolean.valueOf(true));
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").process((Processor)new MyProcessor());
            }
        });
        context.start();
        ProducerTemplate template = context.createProducerTemplate();
        Object out = template.requestBody("direct:start", (Object)"Hello World");
        Assertions.assertEquals((Object)"LineNumberProcessorDebuggingTest.java:40", (Object)out);
    }

    private static class MyProcessor
    implements Processor,
    LineNumberAware {
        private int lineNumber;
        private String location;

        private MyProcessor() {
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public void process(Exchange exchange) {
            exchange.getMessage().setBody((Object)(this.location + ":" + this.lineNumber));
        }
    }
}

