/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LambdaRouteBuilderTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testLambda() throws Exception {
        Assertions.assertEquals((int)0, (int)this.context.getRoutesSize());
        final LambdaRouteBuilder builder = rb -> rb.from("direct:start").to("mock:result");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder((CamelContext)this.context){

            public void configure() throws Exception {
                builder.accept((Object)this);
            }
        });
        this.context.start();
        Assertions.assertEquals((int)1, (int)this.context.getRoutesSize());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testLambdaTwo() throws Exception {
        Assertions.assertEquals((int)0, (int)this.context.getRoutesSize());
        RouteBuilder.addRoutes((CamelContext)this.context, rb -> rb.from("direct:start").to("mock:result"));
        this.context.start();
        Assertions.assertEquals((int)1, (int)this.context.getRoutesSize());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testLambdaSimple() throws Exception {
        Assertions.assertEquals((int)0, (int)this.context.getRoutesSize());
        RouteBuilder.addRoutes((CamelContext)this.context, rb -> ((RouteDefinition)rb.from("direct:start").transform((Expression)rb.simple("Hello ${body}"))).to("mock:result"));
        this.context.start();
        Assertions.assertEquals((int)1, (int)this.context.getRoutesSize());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }
}

