/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InlinedProcessorIdTest
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo")).id("log")).process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getIn().setHeader("foo", (Object)123);
                    }
                })).id("inlined")).to("mock:result")).id("result");
            }
        };
    }

    @Test
    public void testInlinedProcessorId() throws Exception {
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)123);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        RouteDefinition route = this.context.getRouteDefinition("foo");
        Assertions.assertEquals((Object)"foo", (Object)route.getId());
        Assertions.assertEquals((int)3, (int)route.getOutputs().size());
        Assertions.assertEquals((Object)"log", (Object)((ProcessorDefinition)route.getOutputs().get(0)).getId());
        Assertions.assertEquals((Object)"inlined", (Object)((ProcessorDefinition)route.getOutputs().get(1)).getId());
        Assertions.assertEquals((Object)"result", (Object)((ProcessorDefinition)route.getOutputs().get(2)).getId());
    }
}

