/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.IdempotentRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IdempotentConsumerUsingCustomRepositoryTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;
    protected final IdempotentRepository customRepo = new MyRepo();

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), IdempotentConsumerUsingCustomRepositoryTest.this.customRepo).to("mock:result");
            }
        };
    }

    @Test
    public void testDuplicateMessagesAreFilteredOut() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("4", "four");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)this.customRepo.contains("1"));
        Assertions.assertTrue((boolean)this.customRepo.contains("2"));
        Assertions.assertTrue((boolean)this.customRepo.contains("3"));
        Assertions.assertTrue((boolean)this.customRepo.contains("4"));
        Assertions.assertFalse((boolean)this.customRepo.contains("5"));
        this.customRepo.clear();
        Assertions.assertFalse((boolean)this.customRepo.contains("1"));
        Assertions.assertFalse((boolean)this.customRepo.contains("2"));
        Assertions.assertFalse((boolean)this.customRepo.contains("3"));
        Assertions.assertFalse((boolean)this.customRepo.contains("4"));
        Assertions.assertFalse((boolean)this.customRepo.contains("5"));
    }

    protected void sendMessage(final Object messageId, final Object body) {
        this.template.send(this.startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("messageId", messageId);
            }
        });
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    private static final class MyRepo
    implements IdempotentRepository {
        private final Map<String, String> cache = new HashMap<String, String>();

        private MyRepo() {
            this.cache.put("4", "4");
        }

        public boolean add(String key) {
            if (this.cache.containsKey(key)) {
                return false;
            }
            this.cache.put(key, key);
            return true;
        }

        public void clear() {
            this.cache.clear();
        }

        public boolean contains(String key) {
            return this.cache.containsKey(key);
        }

        public boolean remove(String key) {
            return this.cache.remove(key) != null;
        }

        public boolean confirm(String key) {
            return true;
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

