/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.junit.jupiter.api.Test;

public class IdempotentConsumerRepoExceptionTest
extends ContextTestSupport {
    private final IdempotentRepository myRepo = new MyRepo();

    @Test
    public void testRepoException() throws Exception {
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"nineninenine"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.template.sendBodyAndHeader("direct:start", (Object)"one", "messageId", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"two", "messageId", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"one", "messageId", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"nineninenine", "messageId", (Object)"999");
        this.template.sendBodyAndHeader("direct:start", (Object)"two", "messageId", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"three", "messageId", (Object)"3");
        this.template.sendBodyAndHeader("direct:start", (Object)"one", "messageId", (Object)"1");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), IdempotentConsumerRepoExceptionTest.this.myRepo).to("mock:result");
            }
        };
    }

    private static class MyRepo
    extends MemoryIdempotentRepository {
        private MyRepo() {
        }

        public boolean add(String key) {
            if ("999".equals(key)) {
                throw new IllegalArgumentException("Forced");
            }
            return super.add(key);
        }
    }
}

