/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.IdempotentConsumerDefinition;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.junit.jupiter.api.Test;

public class IdempotentConsumerDslTest
extends ContextTestSupport {
    @Test
    public void testDuplicateMessages() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.template.sendBodyAndHeader("direct:start", (Object)"one", "messageId", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"two", "messageId", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"one", "messageId", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"two", "messageId", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"one", "messageId", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"three", "messageId", (Object)"3");
        mock.assertIsSatisfied();
    }

    public IdempotentRepository createRepo() {
        return MemoryIdempotentRepository.memoryIdempotentRepository((int)200);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((IdempotentConsumerDefinition)this.from("direct:start").idempotentConsumer().message(m -> m.getHeader("messageId"))).idempotentRepository(IdempotentConsumerDslTest.this.createRepo()).to("mock:result");
            }
        };
    }
}

