/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IdempotentConsumerCompletionEagerTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;
    protected MockEndpoint a;
    protected MockEndpoint b;
    protected MockEndpoint dead;
    protected IdempotentRepository repo;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testCompletionEager() throws Exception {
        this.repo = MemoryIdempotentRepository.memoryIdempotentRepository((int)200);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), IdempotentConsumerCompletionEagerTest.this.repo).completionEager(true).to(new String[]{"log:a", "mock:a"})).to(new String[]{"log:b", "mock:b"})).end().filter((Predicate)this.simple("${header.messageId} == '2'")).throwException((Exception)new IllegalArgumentException("Forced"))).end().to(new String[]{"log:result", "mock:result"});
            }
        });
        this.context.start();
        this.a.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.b.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.dead.expectedBodiesReceived(new Object[]{"two", "two"});
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "one", "one", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNotCompletionEager() throws Exception {
        this.repo = MemoryIdempotentRepository.memoryIdempotentRepository((int)200);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), IdempotentConsumerCompletionEagerTest.this.repo).completionEager(false).to(new String[]{"log:a", "mock:a"})).to(new String[]{"log:b", "mock:b"})).end().filter((Predicate)this.simple("${header.messageId} == '2'")).throwException((Exception)new IllegalArgumentException("Forced"))).end().to(new String[]{"log:result", "mock:result"});
            }
        });
        this.context.start();
        this.a.expectedBodiesReceived(new Object[]{"one", "two", "two", "three"});
        this.b.expectedBodiesReceived(new Object[]{"one", "two", "two", "three"});
        this.dead.expectedBodiesReceived(new Object[]{"two", "two"});
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "one", "one", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
    }

    protected void sendMessage(final Object messageId, final Object body) {
        this.template.send(this.startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("messageId", messageId);
            }
        });
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
        this.a = this.getMockEndpoint("mock:a");
        this.b = this.getMockEndpoint("mock:b");
        this.dead = this.getMockEndpoint("mock:dead");
    }
}

