/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromVariableTest
extends ContextTestSupport {
    @Test
    public void testOriginalBody() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye "});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOriginalHeaders() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye "});
        this.getMockEndpoint("mock:foo").expectedHeaderReceived("foo", (Object)456);
        this.getMockEndpoint("mock:foo").whenAnyExchangeReceived(e -> {
            Map m = (Map)e.getVariable("header:myKey", Map.class);
            Assertions.assertNotNull((Object)m);
            Assertions.assertEquals((int)1, (int)m.size());
            Assertions.assertEquals((Object)123, m.get("foo"));
        });
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)456);
        this.template.sendBodyAndHeader("direct:start", (Object)"World", "foo", (Object)123);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)this.fromV("direct:start", "myKey").setHeader("foo", (Expression)this.constant(456))).setHeader("bar", (Expression)this.constant("Murphy"))).transform().simple("Bye ${body}")).to("mock:foo")).setBody((Expression)this.simple("${variable:myKey}"))).to("mock:result");
            }
        };
    }
}

