/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromToInOutTest
extends ContextTestSupport {
    @Test
    public void testInOut() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", ExchangePattern.InOnly, (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to(ExchangePattern.InOut, "direct:foo")).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)ExchangePattern.InOut, (Object)exchange.getPattern());
                    }
                })).to("mock:foo");
            }
        };
    }
}

