/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.FlipRoutePolicy;
import org.apache.camel.spi.RoutePolicy;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="This test has a rather strict dependency on timing and threads under the hood, therefore run in isolated mode to reduce flakiness")
public class FlipRoutePolicyTest
extends ContextTestSupport {
    @Test
    public void testFlipRoutePolicyTest() throws Exception {
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMinimumMessageCount(3);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMinimumMessageCount(3);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                FlipRoutePolicy policy = new FlipRoutePolicy("foo", "bar");
                ((RouteDefinition)((ProcessorDefinition)this.from("timer://foo?delay=0&period=10").routeId("foo").routePolicy(new RoutePolicy[]{policy}).setBody().constant((Object)"Foo message")).to("log:foo")).to("mock:foo");
                ((RouteDefinition)((ProcessorDefinition)this.from("timer://bar?delay=0&period=10").routeId("bar").routePolicy(new RoutePolicy[]{policy}).autoStartup(false).setBody().constant((Object)"Bar message")).to("log:bar")).to("mock:bar");
            }
        };
    }
}

