/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Test;

public class FilterStatusPropertyTest
extends ContextTestSupport {
    @Test
    public void testSendMatchingMessage() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:bar").message(0).exchangeProperty("myBar")).isEqualTo((Object)true);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).exchangeProperty("myBar")).isEqualTo((Object)true);
        this.template.sendBodyAndHeader("direct:start", (Object)"<matched/>", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendNotMatchingMessage() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).exchangeProperty("myBar")).isEqualTo((Object)false);
        this.template.sendBodyAndHeader("direct:start", (Object)"<notMatched/>", "foo", (Object)"notMatchedHeaderValue");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").filter(this.header("foo").isEqualTo((Object)"bar")).statusPropertyName("myBar").to("mock:bar")).end().to("mock:result");
            }
        };
    }
}

