/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Test;

public class FilterNotMatchedTest
extends ContextTestSupport {
    @Test
    public void testSendMatchingMessage() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"<matched/>", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendNotMatchingMessage() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"<notMatched/>", "foo", (Object)"notMatchedHeaderValue");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").filter(this.header("foo").isEqualTo((Object)"bar")).to("mock:result")).end().to("mock:end");
            }
        };
    }
}

