/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileRollbackOnCompletionTest
extends ContextTestSupport {
    private static final CountDownLatch LATCH = new CountDownLatch(1);

    @Test
    public void testOk() throws Exception {
        this.template.sendBodyAndHeader("direct:confirm", (Object)"bumper", "to", (Object)"someone@somewhere.org");
        try (Stream<Path> list = Files.list(this.testDirectory());){
            long files = list.count();
            Assertions.assertEquals((long)1L, (long)files, (String)"There should be one file");
        }
    }

    @Test
    public void testRollback() throws Exception {
        try {
            this.template.sendBodyAndHeader("direct:confirm", (Object)"bumper", "to", (Object)"FATAL");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            FileRollbackOnCompletionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertEquals((Object)"Simulated fatal error", (Object)e.getCause().getMessage());
        }
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertTrue((boolean)LATCH.await(5L, TimeUnit.SECONDS), (String)"Should countdown the latch");
        try (Stream<Path> list = Files.list(this.testDirectory());){
            long files = list.count();
            Assertions.assertEquals((long)0L, (long)files, (String)"There should be no files");
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnCompletionDefinition)this.from("direct:confirm").onCompletion().onFailureOnly().bean(FileRollback.class, "onFailure")).end().bean(OrderService.class, "createMail").log("Saving mail backup file").to(FileRollbackOnCompletionTest.this.fileUri()).log("Trying to send mail to ${header.to}").bean(OrderService.class, "sendMail").log("Mail send to ${header.to}");
            }
        };
    }

    public static final class OrderService {
        public String createMail(String order) {
            return "Order confirmed: " + order;
        }

        public void sendMail(String body, @Header(value="to") String to) {
            if (to.equals("FATAL")) {
                throw new IllegalArgumentException("Simulated fatal error");
            }
        }
    }

    public static final class FileRollback
    implements Synchronization {
        public void onComplete(Exchange exchange) {
        }

        public void onFailure(Exchange exchange) {
            String name = (String)exchange.getIn().getHeader("CamelFileNameProduced", String.class);
            FileUtil.deleteFile((File)new File(name));
            LATCH.countDown();
        }
    }
}

