/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Stream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.processor.idempotent.FileIdempotentRepository;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileIdempotentTrunkStoreTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;
    private IdempotentRepository repo;
    private File store;

    @Test
    public void testTrunkFileStore() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"A", "B", "C", "D", "E"});
        this.sendMessage("AAAAAAAAAA", "A");
        this.sendMessage("BBBBBBBBBB", "B");
        this.sendMessage("CCCCCCCCCC", "C");
        this.sendMessage("AAAAAAAAAA", "A");
        this.sendMessage("DDDDDDDDDD", "D");
        this.sendMessage("BBBBBBBBBB", "B");
        this.sendMessage("EEEEEEEEEE", "E");
        this.resultEndpoint.assertIsSatisfied();
        this.resultEndpoint.reset();
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"Z", "X"});
        this.sendMessage("ZZZZZZZZZZ", "Z");
        this.sendMessage("XXXXXXXXXX", "X");
        this.resultEndpoint.assertIsSatisfied();
        Assertions.assertTrue((boolean)this.repo.contains("XXXXXXXXXX"));
        try (Stream<String> fileContent = Files.lines(this.store.toPath());){
            List<String> fileEntries = fileContent.toList();
            MatcherAssert.assertThat(fileEntries, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"ZZZZZZZZZZ", "XXXXXXXXXX"}));
        }
    }

    protected void sendMessage(final Object messageId, final Object body) {
        this.template.send(this.startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("messageId", messageId);
            }
        });
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.store = this.testFile("idempotentfilestore.dat").toFile();
        if (this.store.exists()) {
            this.store.delete();
        }
        this.repo = FileIdempotentRepository.fileIdempotentRepository((File)this.store, (int)5, (long)50L);
        this.repo.start();
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), FileIdempotentTrunkStoreTest.this.repo).to("mock:result");
            }
        };
    }
}

