/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.processor.idempotent.FileIdempotentRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileIdempotentConsumerLoadStoreTest
extends ContextTestSupport {
    private IdempotentRepository repo;

    @Test
    public void testLoadStore() throws Exception {
        Endpoint startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        Assertions.assertFalse((boolean)this.repo.contains("1"));
        Assertions.assertFalse((boolean)this.repo.contains("2"));
        Assertions.assertFalse((boolean)this.repo.contains("3"));
        Assertions.assertTrue((boolean)this.repo.contains("4"));
        resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.sendMessage(startEndpoint, "1", "one");
        this.sendMessage(startEndpoint, "2", "two");
        this.sendMessage(startEndpoint, "1", "one");
        this.sendMessage(startEndpoint, "2", "two");
        this.sendMessage(startEndpoint, "4", "four");
        this.sendMessage(startEndpoint, "1", "one");
        this.sendMessage(startEndpoint, "3", "three");
        resultEndpoint.assertIsSatisfied();
        Assertions.assertTrue((boolean)this.repo.contains("1"));
        Assertions.assertTrue((boolean)this.repo.contains("2"));
        Assertions.assertTrue((boolean)this.repo.contains("3"));
        Assertions.assertTrue((boolean)this.repo.contains("4"));
    }

    protected void sendMessage(Endpoint startEndpoint, final Object messageId, final Object body) {
        this.template.send(startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("messageId", messageId);
            }
        });
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        File store = this.testFile("idempotentfilestore.dat").toFile();
        try (FileOutputStream fos = new FileOutputStream(store);){
            fos.write("4\n".getBytes());
        }
        this.repo = FileIdempotentRepository.fileIdempotentRepository((File)store);
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), FileIdempotentConsumerLoadStoreTest.this.repo).to("mock:result");
            }
        };
    }
}

