/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import java.util.UUID;
import org.apache.camel.TestSupport;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.processor.idempotent.FileIdempotentRepository;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileIdempotentConsumerCreateRepoTest
extends TestSupport {
    File store;

    @Test
    public void shouldCreateParentOfRepositoryFileStore() throws Exception {
        File parentDirectory = this.testDirectory("repositoryParent_" + String.valueOf(UUID.randomUUID())).toFile();
        this.store = new File(parentDirectory, "store");
        this.assertStoreExists(this.store);
    }

    @Test
    public void shouldUseCurrentDirIfHasNoParentFile() throws Exception {
        String storeFileName = "store" + String.valueOf(UUID.randomUUID());
        this.store = new File(storeFileName);
        this.assertStoreExists(this.store);
    }

    private void assertStoreExists(File store) {
        IdempotentRepository repo = FileIdempotentRepository.fileIdempotentRepository((File)store);
        repo.start();
        repo.add("anyKey");
        Assertions.assertTrue((boolean)store.exists());
        repo.stop();
    }

    @AfterEach
    public void after() {
        FileUtil.deleteFile((File)this.store);
    }
}

