/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.processor.idempotent.FileIdempotentRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileIdempotentClearTest
extends ContextTestSupport {
    private IdempotentRepository repo;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        File store = this.testFile("idempotentfilestore.dat").toFile();
        if (store.exists()) {
            store.delete();
        }
        this.repo = FileIdempotentRepository.fileIdempotentRepository((File)store);
        super.setUp();
    }

    @Test
    public void testClear() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Foo", "Bar"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Foo", "messageId", (Object)"A");
        this.template.sendBodyAndHeader("direct:start", (Object)"Camel rocks", "messageId", (Object)"A");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bar", "messageId", (Object)"B");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Camel rocks"});
        this.repo.clear();
        Assertions.assertFalse((boolean)this.repo.contains("A"));
        Assertions.assertFalse((boolean)this.repo.contains("B"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), FileIdempotentClearTest.this.repo).to("mock:result");
            }
        };
    }
}

