/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FailoverMaximumFailoverAttemptsTest
extends ContextTestSupport {
    @Test
    public void testFailoverMaximumFailoverAttempts() throws Exception {
        this.getMockEndpoint("mock:bad").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bad2").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bad3").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:good").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should throw exception");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"Damn Again Again", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        this.getMockEndpoint("mock:bad").expectedMessageCount(0);
        this.getMockEndpoint("mock:bad2").expectedMessageCount(0);
        this.getMockEndpoint("mock:bad3").expectedMessageCount(0);
        this.getMockEndpoint("mock:good").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance().failover(2, false, true, new Class[0]).to(new String[]{"direct:bad", "direct:bad2", "direct:bad3", "direct:good"});
                ((RouteDefinition)((RouteDefinition)this.from("direct:bad").to("log:bad")).to("mock:bad")).throwException((Exception)new IllegalArgumentException("Damn"));
                ((RouteDefinition)((RouteDefinition)this.from("direct:bad2").to("log:bad2")).to("mock:bad2")).throwException((Exception)new IllegalArgumentException("Damn Again"));
                ((RouteDefinition)((RouteDefinition)this.from("direct:bad3").to("log:bad3")).to("mock:bad3")).throwException((Exception)new IllegalArgumentException("Damn Again Again"));
                ((RouteDefinition)this.from("direct:good").to("log:good")).to("mock:good");
            }
        };
    }
}

