/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FailoverLoadBalancerBreakoutDuringShutdownTest
extends ContextTestSupport {
    @Test
    public void testFailover() throws Exception {
        this.getMockEndpoint("mock:before").expectedMessageCount(1);
        this.getMockEndpoint("mock:after").expectedMessageCount(0);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        StopWatch watch = new StopWatch();
        this.context.getShutdownStrategy().setTimeout(1L);
        this.context.stop();
        Assertions.assertTrue((watch.taken() < 5000L ? 1 : 0) != 0, (String)("Should take less than 5 seconds, was " + watch.taken()));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((LoadBalanceDefinition)((LoadBalanceDefinition)((RouteDefinition)this.from("seda:start").to("mock:before")).loadBalance().failover(-1, false, true, new Class[0]).to("direct:a")).to("direct:b")).end().to("mock:after");
                this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) {
                        throw new IllegalArgumentException("Forced");
                    }
                });
                this.from("direct:b").process(new Processor(){

                    public void process(Exchange exchange) {
                        throw new IllegalArgumentException("Forced");
                    }
                });
            }
        };
    }
}

