/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import java.net.SocketException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FailOverNotCatchedExceptionTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance().failover(new Class[]{IOException.class}).to(new String[]{"direct:x", "direct:y", "direct:z"});
                ((RouteDefinition)this.from("direct:x").to("mock:x")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new SocketException("Forced");
                    }
                });
                ((RouteDefinition)this.from("direct:y").to("mock:y")).process(new Processor(){

                    public void process(Exchange exchange) {
                        throw new IllegalArgumentException("Illegal");
                    }
                });
                this.from("direct:z").to("mock:z");
            }
        };
    }

    @Test
    public void testExceptionNotCatched() throws Exception {
        this.x.expectedMessageCount(1);
        this.y.expectedMessageCount(1);
        this.z.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Illegal", (Object)e.getCause().getMessage());
            FailOverNotCatchedExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }
}

