/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FailOverLoadBalancerSetFaultTest
extends ContextTestSupport {
    @Test
    public void testFailOverSetFault() throws Exception {
        this.getMockEndpoint("mock:failover1").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:failover2").expectedBodiesReceived(new Object[]{"Hello World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        Assertions.assertEquals((Object)"Bye Camel", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((LoadBalanceDefinition)this.from("direct:start").loadBalance().failover(1, false, false, new Class[]{IOException.class}).to(new String[]{"seda:failover1", "seda:failover2"})).end();
                ((RouteDefinition)this.from("seda:failover1").to("mock:failover1")).process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getMessage().setBody((Object)"Hi Camel");
                        exchange.setException((Throwable)new IOException("Forced exception for test"));
                    }
                });
                ((RouteDefinition)this.from("seda:failover2").to("mock:failover2")).process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getMessage().setBody((Object)"Bye Camel");
                    }
                });
            }
        };
    }
}

