/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FailOverLoadBalanceWithRedeliveryTest
extends ContextTestSupport {
    private static int counter;

    @Test
    public void testFailoverWithRedelivery() throws Exception {
        counter = 0;
        MockEndpoint a = this.getMockEndpoint("mock:a");
        a.expectedMessageCount(3);
        MockEndpoint b = this.getMockEndpoint("mock:b");
        b.expectedMessageCount(2);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(2).redeliveryDelay(0L));
                this.from("direct:start").loadBalance().failover().to(new String[]{"direct:a", "direct:b"});
                ((RouteDefinition)this.from("direct:a").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:a")).throwException((Exception)new IllegalArgumentException("I cannot do this"));
                ((RouteDefinition)((RouteDefinition)this.from("direct:b").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:b")).process(new Processor(){

                    public void process(Exchange exchange) {
                        if (counter++ < 1) {
                            throw new IllegalArgumentException("I can still not do this");
                        }
                        exchange.getIn().setBody((Object)"Bye World");
                    }
                })).to("mock:result");
            }
        };
    }
}

