/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FailOverLoadBalanceTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:exception").loadBalance().failover().to(new String[]{"direct:x", "direct:y", "direct:z"});
                this.from("direct:customerException").loadBalance().failover(new Class[]{MyException.class}).to(new String[]{"direct:x", "direct:y", "direct:z"});
                ((RouteDefinition)this.from("direct:x").process((Processor)new MyExceptionProcessor())).to("mock:x");
                ((RouteDefinition)this.from("direct:y").process((Processor)new MyAnotherExceptionProcessor())).to("mock:y");
                this.from("direct:z").to("mock:z");
            }
        };
    }

    @Test
    public void testThrowable() throws Exception {
        String body = "<one/>";
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.x, this.y});
        this.z.expectedBodiesReceived(new Object[]{body});
        this.sendMessage("direct:exception", "bar", body);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMyException() throws Exception {
        String body = "<two/>";
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.x, this.y, this.z});
        try {
            this.sendMessage("direct:customerException", "bar", body);
            Assertions.fail((String)"There should get the MyAnotherException");
        }
        catch (RuntimeCamelException ex) {
            boolean b = ex.getCause() instanceof MyAnotherException;
            Assertions.assertTrue((boolean)b, (String)"The cause should be MyAnotherException");
        }
        this.assertMockEndpointsSatisfied();
    }

    protected void sendMessage(String endpoint, Object headerValue, Object body) {
        this.template.sendBodyAndHeader(endpoint, body, "foo", headerValue);
    }

    public static class MyAnotherException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static class MyAnotherExceptionProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            throw new MyAnotherException();
        }
    }

    public static class MyExceptionProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            throw new MyException();
        }
    }

    public static class MyException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

