/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExpressionPlaceholderNestedTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        Properties myProp = new Properties();
        myProp.put("query", "{\"query\":{\"match_all\":{}}}");
        myProp.put("queryEscaped", "{\"query\":{\"match_all\":{}\\}}");
        context.getPropertiesComponent().setInitialProperties(myProp);
        return context;
    }

    @Test
    public void testPlaceholderFalse() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"{\"query\":{\"match_all\":{}}}"});
        this.template.sendBody("direct:off", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testPlaceholderOn() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ((ProcessorDefinition)this.from("direct:on").setBody().constant((Object)"{{query?nested=true}}")).to("mock:result");
                }
            });
            Assertions.fail();
        }
        catch (FailedToCreateRouteException e) {
            ExpressionPlaceholderNestedTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        }
    }

    @Test
    public void testPlaceholderEscaped() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"{\"query\":{\"match_all\":{}}}"});
        this.template.sendBody("direct:escaped", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:off").setBody().constant((Object)"{{query?nested=false}}")).to("mock:result");
                ((ProcessorDefinition)this.from("direct:escaped").setBody().constant((Object)"{{queryEscaped}}")).to("mock:result");
            }
        };
    }
}

