/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExchangeCreatedTimestampTest
extends ContextTestSupport {
    @Test
    public void testCreatedTimestamp() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        long created = ((Exchange)mock.getReceivedExchanges().get(0)).getClock().getCreated();
        Assertions.assertTrue((created > 0L ? 1 : 0) != 0);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:start").delay(500L).to("direct:foo");
                ((RouteDefinition)this.from("direct:foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

