/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.MySentEventNotifier;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventNotifierExchangeSentTest
extends ContextTestSupport {
    private final MySentEventNotifier notifier = new MySentEventNotifier();

    @Override
    protected CamelContext createCamelContext() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getManagementStrategy().addEventNotifier((EventNotifier)this.notifier);
        return context;
    }

    @Test
    public void testExchangeSent() throws Exception {
        Assertions.assertEquals((int)0, (int)this.notifier.getEvents().size());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)this.notifier.getEvents().size());
        CamelEvent.ExchangeSentEvent e = (CamelEvent.ExchangeSentEvent)this.notifier.getEvents().get(0);
        Assertions.assertEquals((Object)"mock://bar", (Object)e.getEndpoint().getEndpointUri());
        e = (CamelEvent.ExchangeSentEvent)this.notifier.getEvents().get(1);
        Assertions.assertEquals((Object)"direct://bar", (Object)e.getEndpoint().getEndpointUri());
        e = (CamelEvent.ExchangeSentEvent)this.notifier.getEvents().get(2);
        Assertions.assertEquals((Object)"mock://result", (Object)e.getEndpoint().getEndpointUri());
        e = (CamelEvent.ExchangeSentEvent)this.notifier.getEvents().get(3);
        Assertions.assertEquals((Object)"direct://start", (Object)e.getEndpoint().getEndpointUri());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("direct:bar")).to("mock:result");
                this.from("direct:bar").to("mock:bar");
            }
        };
    }
}

