/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ErrorHandlerWrappedEachNodeTest
extends ContextTestSupport {
    private static int kaboom;
    private static int hi;

    @Test
    public void testKaboom() throws Exception {
        kaboom = 0;
        hi = 0;
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hi Kaboom"});
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)kaboom);
        Assertions.assertEquals((int)1, (int)hi);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").maximumRedeliveries(3).redeliveryDelay(0L).logStackTrace(false));
                ((RouteDefinition)this.from("direct:start").pipeline(new String[]{"bean:foo?method=hi", "bean:foo?method=kaboom"})).to("mock:result");
            }
        };
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    public static final class MyFooBean {
        public void kaboom() {
            if (kaboom++ < 2) {
                throw new IllegalArgumentException("Kaboom");
            }
        }

        public String hi(String payload) {
            ++hi;
            return "Hi " + payload;
        }
    }
}

