/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import java.net.ConnectException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ErrorHandlerOnExceptionRedeliveryAndHandledTest
extends ContextTestSupport {
    private static String counter = "";

    @Test
    public void testRedeliveryCounterIsResetWhenHandled() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            ConnectException cause = ErrorHandlerOnExceptionRedeliveryAndHandledTest.assertIsInstanceOf(ConnectException.class, e.getCause());
            Assertions.assertEquals((Object)"Cannot connect to bar server", (Object)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"123", (Object)counter);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(5).redeliveryDelay(0L));
                ((OnExceptionDefinition)this.onException(IOException.class).maximumRedeliveries(3).handled(true).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        if (exchange.getIn().getHeader("CamelRedelivered") != null) {
                            String s = (String)exchange.getIn().getHeader("CamelRedeliveryCounter", String.class);
                            counter = counter + s;
                        }
                        throw new ConnectException("Cannot connect to bar server");
                    }
                })).to("mock:other");
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        if (exchange.getIn().getHeader("CamelRedelivered") != null) {
                            String s = (String)exchange.getIn().getHeader("CamelRedeliveryCounter", String.class);
                            counter = counter + s;
                        }
                        throw new ConnectException("Cannot connect to foo server");
                    }
                })).to("mock:result");
            }
        };
    }
}

