/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnrichWithUnitOfWorkTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testEnrichWith() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:routeA").enrichWith("direct:routeB", true, false).body((a, b) -> b);
                this.from("direct:routeB").enrichWith("direct:routeC", true, false).body((a, b) -> b);
                this.from("direct:routeC").setBody((Expression)this.constant("Bye World"));
            }
        });
        this.context.start();
        Exchange out = this.template.request("direct:routeA", new Processor(){

            public void process(Exchange exchange) {
                exchange.getMessage().setBody((Object)"Hello World");
                exchange.getExchangeExtension().addOnCompletion((Synchronization)new SynchronizationAdapter(){

                    public void onDone(Exchange exchange) {
                        exchange.getMessage().setBody((Object)("Done " + String.valueOf(exchange.getMessage().getBody())));
                    }
                });
            }
        });
        Assertions.assertFalse((boolean)out.isFailed());
        Assertions.assertEquals((Object)"Done Bye World", (Object)out.getMessage().getBody());
    }

    @Test
    public void testEnrichWithShareUnitOfWork() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:routeA").enrichWith("direct:routeB", true, true).body((a, b) -> b);
                this.from("direct:routeB").enrichWith("direct:routeC", true, true).body((a, b) -> b);
                this.from("direct:routeC").setBody((Expression)this.constant("Bye World"));
            }
        });
        this.context.start();
        Exchange out = this.template.request("direct:routeA", new Processor(){

            public void process(Exchange exchange) {
                exchange.getMessage().setBody((Object)"Hello World");
                exchange.getExchangeExtension().addOnCompletion((Synchronization)new SynchronizationAdapter(){

                    public void onDone(Exchange exchange) {
                        exchange.getMessage().setBody((Object)("Done " + String.valueOf(exchange.getMessage().getBody())));
                    }
                });
            }
        });
        Assertions.assertFalse((boolean)out.isFailed());
        Assertions.assertEquals((Object)"Done Bye World", (Object)out.getMessage().getBody());
    }
}

