/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.processor.Enricher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnrichNoCacheTest
extends ContextTestSupport {
    @Test
    public void testNoCache() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        this.sendBody("foo", "mock:x");
        this.sendBody("foo", "mock:y");
        this.sendBody("foo", "mock:z");
        this.sendBody("bar", "mock:x");
        this.sendBody("bar", "mock:y");
        this.sendBody("bar", "mock:z");
        List<Processor> list = this.getProcessors("foo");
        Enricher ep = (Enricher)list.get(0);
        Assertions.assertNotNull((Object)ep);
        Assertions.assertEquals((int)-1, (int)ep.getCacheSize());
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"foo", "bar"});
        y.expectedBodiesReceived(new Object[]{"foo", "bar"});
        z.expectedBodiesReceived(new Object[]{"foo", "bar"});
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().size());
        this.sendBody("foo", "mock:x");
        this.sendBody("foo", "mock:y");
        this.sendBody("foo", "mock:z");
        this.sendBody("bar", "mock:x");
        this.sendBody("bar", "mock:y");
        this.sendBody("bar", "mock:z");
        this.sendBody("dummy", "mock:dummy");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().size());
    }

    protected void sendBody(String body, String uri) {
        this.template.sendBodyAndHeader("direct:a", (Object)body, "myHeader", (Object)uri);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((EnrichDefinition)this.from("direct:a").enrich().header("myHeader")).cacheSize(-1).end().id("foo");
            }
        };
    }
}

