/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Endpoint2MustBeStartedBeforeSendProcessorTest
extends ContextTestSupport {
    private MyEndpoint myendpoint;
    private volatile String order = "";

    @Test
    public void testEndpointMustBeStartedBeforeProducer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint = new MyEndpoint("myendpoint", (CamelContext)Endpoint2MustBeStartedBeforeSendProcessorTest.this.context);
                this.from("direct:start").to((Endpoint)Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint);
            }
        });
        this.context.start();
        Assertions.assertEquals((Object)"EndpointProducer", (Object)this.order);
    }

    @Test
    public void testEndpointMustBeStartedBeforeConsumer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint = new MyEndpoint("myendpoint", (CamelContext)Endpoint2MustBeStartedBeforeSendProcessorTest.this.context);
                this.from((Endpoint)Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint).to("mock:result");
            }
        });
        this.context.start();
        Assertions.assertEquals((Object)"EndpointConsumer", (Object)this.order);
    }

    @Test
    public void testEndpointMustBeStartedBeforeConsumerAndProducer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint = new MyEndpoint("myendpoint", (CamelContext)Endpoint2MustBeStartedBeforeSendProcessorTest.this.context);
                ((RouteDefinition)this.from((Endpoint)Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint).to("mock:result")).to((Endpoint)Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint);
            }
        });
        this.context.start();
        Assertions.assertEquals((Object)"EndpointProducerConsumer", (Object)this.order);
    }

    @Test
    public void testEndpointStartedOnceAndOnlyStoppedOnShutdown() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint = new MyEndpoint("myendpoint", (CamelContext)Endpoint2MustBeStartedBeforeSendProcessorTest.this.context);
                ((RouteDefinition)this.from((Endpoint)Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint).routeId("foo").to("mock:result")).to((Endpoint)Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint);
            }
        });
        this.context.start();
        Assertions.assertEquals((Object)"EndpointProducerConsumer", (Object)this.order);
        this.order = "";
        this.context.getRouteController().stopRoute("foo");
        Assertions.assertEquals((Object)"StopConsumerStopProducer", (Object)this.order);
        this.order = "";
        this.context.getRouteController().startRoute("foo");
        Assertions.assertEquals((Object)"ProducerConsumer", (Object)this.order);
        this.order = "";
        this.context.stop();
        Assertions.assertEquals((Object)"StopConsumerStopProducerStopEndpoint", (Object)this.order);
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    private class MyConsumer
    extends DefaultConsumer {
        MyConsumer(Endpoint endpoint, Processor processor) {
            super(endpoint, processor);
        }

        protected void doStart() {
            Endpoint2MustBeStartedBeforeSendProcessorTest.this.order = Endpoint2MustBeStartedBeforeSendProcessorTest.this.order + "Consumer";
        }

        protected void doStop() {
            Endpoint2MustBeStartedBeforeSendProcessorTest.this.order = Endpoint2MustBeStartedBeforeSendProcessorTest.this.order + "StopConsumer";
        }
    }

    private class MyProducer
    extends DefaultProducer {
        MyProducer(Endpoint endpoint) {
            super(endpoint);
        }

        public void process(Exchange exchange) {
        }

        protected void doStart() {
            Endpoint2MustBeStartedBeforeSendProcessorTest.this.order = Endpoint2MustBeStartedBeforeSendProcessorTest.this.order + "Producer";
        }

        protected void doStop() {
            Endpoint2MustBeStartedBeforeSendProcessorTest.this.order = Endpoint2MustBeStartedBeforeSendProcessorTest.this.order + "StopProducer";
        }
    }

    private final class MyEndpoint
    extends DefaultEndpoint {
        private MyEndpoint(String endpointUri, CamelContext camelContext) {
            this.setCamelContext(camelContext);
            this.setEndpointUri(endpointUri);
        }

        public Producer createProducer() {
            return new MyProducer((Endpoint)this);
        }

        public Consumer createConsumer(Processor processor) {
            return new MyConsumer((Endpoint)this, null);
        }

        public boolean isSingleton() {
            return true;
        }

        public void doStart() {
            Endpoint2MustBeStartedBeforeSendProcessorTest.this.order = Endpoint2MustBeStartedBeforeSendProcessorTest.this.order + "Endpoint";
        }

        public void doStop() {
            Endpoint2MustBeStartedBeforeSendProcessorTest.this.order = Endpoint2MustBeStartedBeforeSendProcessorTest.this.order + "StopEndpoint";
        }
    }
}

