/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DynamicRouterTest
extends ContextTestSupport {
    private static int invoked;
    private static final List<String> bodies;

    @Test
    public void testDynamicRouter() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)5, (int)invoked);
        Assertions.assertEquals((int)5, (int)bodies.size());
        Assertions.assertEquals((Object)"Hello World", (Object)bodies.get(0));
        Assertions.assertEquals((Object)"Hello World", (Object)bodies.get(1));
        Assertions.assertEquals((Object)"Hello World", (Object)bodies.get(2));
        Assertions.assertEquals((Object)"Bye World", (Object)bodies.get(3));
        Assertions.assertEquals((Object)"Bye World", (Object)bodies.get(4));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").dynamicRouter((Expression)this.method(DynamicRouterTest.class, "slip"));
                this.from("direct:foo").transform((Expression)this.constant("Bye World"));
            }
        };
    }

    public String slip(String body) {
        bodies.add(body);
        if (++invoked == 1) {
            return "mock:a";
        }
        if (invoked == 2) {
            return "mock:b,mock:c";
        }
        if (invoked == 3) {
            return "direct:foo";
        }
        if (invoked == 4) {
            return "mock:result";
        }
        return null;
    }

    static {
        bodies = new ArrayList<String>();
    }
}

