/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.support.ExchangeHelper;
import org.junit.jupiter.api.Test;

public class DynamicRouter4Test
extends ContextTestSupport {
    @Test
    public void testDynamicRouter() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.template.sendBody("direct:start-1", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start-1").dynamicRouter().exchange(DynamicRouter4Test::slip);
            }
        };
    }

    public static String slip(Exchange exchange) {
        String previous = (String)ExchangeHelper.getHeaderOrProperty((Exchange)exchange, (String)"CamelSlipEndpoint", String.class);
        if (previous == null) {
            return "mock:a,mock:b";
        }
        if ("mock://b".equals(previous)) {
            return "mock:c";
        }
        return null;
    }
}

