/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class DynamicRouter2Test
extends ContextTestSupport {
    @Test
    public void testDynamicRouter() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").dynamicRouter().method(DynamicRouter2Test.class, "slip");
            }
        };
    }

    public String slip(String body, @Header(value="CamelSlipEndpoint") String previous) {
        if (previous == null) {
            return "mock:a";
        }
        if ("mock://a".equals(previous)) {
            return "mock:b";
        }
        if ("mock://b".equals(previous)) {
            return "mock:result";
        }
        return null;
    }
}

