/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DoubleLoadBalancerMisconfigurationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testMisconfiguration() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    this.from("direct:start").loadBalance().failover().roundRobin().to(new String[]{"mock:a", "mock:b"});
                }
            });
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Loadbalancer already configured to: FailoverLoadBalancer. Cannot set it to: RoundRobinLoadBalancer", (Object)e.getMessage());
        }
    }

    @Test
    public void testMisconfiguration2() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    this.from("direct:start").loadBalance().failover().random().to(new String[]{"mock:a", "mock:b"});
                }
            });
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Loadbalancer already configured to: FailoverLoadBalancer. Cannot set it to: RandomLoadBalancer", (Object)e.getMessage());
        }
    }

    @Test
    public void testMisconfiguration3() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    this.from("direct:start").loadBalance().random().failover().to(new String[]{"mock:a", "mock:b"});
                }
            });
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Loadbalancer already configured to: RandomLoadBalancer. Cannot set it to: FailoverLoadBalancer", (Object)e.getMessage());
        }
    }
}

