/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DelayerWhileShutdownTest
extends ContextTestSupport {
    private final Phaser phaser = new Phaser(2);

    @BeforeEach
    void sendEarly() {
        this.template.sendBody("seda:a", (Object)"Long delay");
        this.template.sendBody("seda:b", (Object)"Short delay");
    }

    @Test
    public void testSendingMessageGetsDelayed() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Short delay"});
        this.phaser.awaitAdvanceInterruptibly(0, 5000L, TimeUnit.SECONDS);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:a").process(e -> DelayerWhileShutdownTest.this.phaser.arriveAndAwaitAdvance())).delay(1000L).to("mock:result");
                ((RouteDefinition)this.from("seda:b").process(e -> DelayerWhileShutdownTest.this.phaser.arriveAndAwaitAdvance())).delay(1L).to("mock:result");
            }
        };
    }
}

