/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.DelayDefinition;
import org.apache.camel.processor.ExchangeAwareDelayCalcBean;
import org.apache.camel.processor.MyDelayCalcBean;
import org.junit.jupiter.api.Test;

public class DelayerTest
extends ContextTestSupport {
    private final MyDelayCalcBean bean = new MyDelayCalcBean();
    private final ExchangeAwareDelayCalcBean exchangeAwareBean = new ExchangeAwareDelayCalcBean();

    @Test
    public void testSendingMessageGetsDelayed() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(0);
        resultEndpoint.setResultWaitTime(10L);
        this.template.sendBodyAndHeader("seda:a", (Object)"<hello>world!</hello>", "MyDelay", (Object)100);
        resultEndpoint.assertIsSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testDelayConstant() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.setResultMinimumWaitTime(90L);
        this.template.sendBody("seda:b", (Object)"<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testDelayBean() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.setResultMinimumWaitTime(90L);
        this.template.sendBody("seda:c", (Object)"<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testExchangeAwareDelayBean() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.setResultMinimumWaitTime(90L);
        this.template.sendBodyAndHeader("seda:d", (Object)"<hello>world!</hello>", "BEAN_DELAYER_HEADER", (Object)100);
        resultEndpoint.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((DelayDefinition)this.from("seda:a").delay().header("MyDelay")).to("mock:result");
                this.from("seda:b").delay(100L).to("mock:result");
                ((DelayDefinition)this.from("seda:c").delay().method((Object)DelayerTest.this.bean, "delayMe")).to("mock:result");
                ((DelayDefinition)this.from("seda:d").delay().method((Object)DelayerTest.this.exchangeAwareBean, "delayMe")).to("mock:result");
            }
        };
    }
}

