/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SetBodyDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefinitionPolicyPerProcessorTest
extends ContextTestSupport {
    @Test
    public void testDefintionAugmentationPolicy() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:foo").expectedBodyReceived().constant((Object)"body was altered");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MyPolicy foo = (MyPolicy)this.context.getRegistry().lookupByNameAndType("foo", MyPolicy.class);
        Assertions.assertEquals((int)1, (int)foo.getInvoked(), (String)"Should only be invoked 1 time");
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyPolicy("foo"));
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((PolicyDefinition)((ProcessorDefinition)this.from("direct:start").policy("foo").setBody().constant((Object)"body not altered")).to("mock:foo")).end();
            }
        };
    }

    public static class MyPolicy
    implements Policy {
        private final String name;
        private int invoked;

        public MyPolicy(String name) {
            this.name = name;
        }

        public int getInvoked() {
            return this.invoked;
        }

        public void beforeWrap(Route route, NamedNode definition) {
            SetBodyDefinition bodyDef = (SetBodyDefinition)((ProcessorDefinition)definition).getOutputs().get(0);
            bodyDef.setExpression((ExpressionDefinition)new ConstantExpression("body was altered"));
        }

        public Processor wrap(Route route, final Processor processor) {
            return new Processor(){

                public void process(Exchange exchange) throws Exception {
                    ++invoked;
                    exchange.getIn().setHeader(name, (Object)"was wrapped");
                    processor.process(exchange);
                }
            };
        }
    }
}

