/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Channel;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.engine.DefaultRoute;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.errorhandler.DefaultErrorHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultErrorHandlerTest
extends ContextTestSupport {
    @Test
    public void testRoute() {
        Route route = (Route)this.context.getRoutes().get(0);
        DefaultRoute consumerRoute = DefaultErrorHandlerTest.assertIsInstanceOf(DefaultRoute.class, route);
        Processor processor = DefaultErrorHandlerTest.unwrap(consumerRoute.getProcessor());
        Pipeline pipeline = DefaultErrorHandlerTest.assertIsInstanceOf(Pipeline.class, processor);
        for (Processor child : pipeline.next()) {
            Channel channel = DefaultErrorHandlerTest.assertIsInstanceOf(Channel.class, child);
            Assertions.assertNotNull((Object)channel.getErrorHandler(), (String)"There should be an error handler");
            DefaultErrorHandlerTest.assertIsInstanceOf(DefaultErrorHandler.class, channel.getErrorHandler());
        }
    }

    @Test
    public void testOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithError() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Kaboom");
            Assertions.fail((String)"Should have thrown a RuntimeCamelException");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Kaboom".equals(body)) {
                            throw new IllegalArgumentException("Boom");
                        }
                        exchange.getIn().setBody((Object)"Bye World");
                    }
                })).to("mock:result");
            }
        };
    }
}

