/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultErrorHandlerRedeliveryTest
extends ContextTestSupport {
    private static int counter;

    @Test
    public void testRedeliveryTest() {
        counter = 0;
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
        Assertions.assertEquals((int)3, (int)counter);
    }

    @Test
    public void testNoRedeliveriesTest() {
        counter = 0;
        try {
            this.template.sendBody("direct:no", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
        Assertions.assertEquals((int)1, (int)counter);
    }

    @Test
    public void testOneRedeliveryTest() {
        counter = 0;
        try {
            this.template.sendBody("direct:one", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
        Assertions.assertEquals((int)2, (int)counter);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().redeliveryDelay(0L).maximumRedeliveries(2)).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ++counter;
                        throw new Exception("Forced exception by unit test");
                    }
                });
                this.from("direct:no").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ++counter;
                        throw new Exception("Forced exception by unit test");
                    }
                });
                this.from("direct:one").errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().redeliveryDelay(0L).maximumRedeliveries(1)).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ++counter;
                        throw new Exception("Forced exception by unit test");
                    }
                });
            }
        };
    }
}

