/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultErrorHandlerRedeliveryRefTest
extends ContextTestSupport {
    private static int counter;

    @Test
    public void testRedeliveryRefTest() {
        counter = 0;
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
        Assertions.assertEquals((int)3, (int)counter);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                RedeliveryPolicy policy = new RedeliveryPolicy();
                policy.maximumRedeliveries(2);
                policy.redeliveryDelay(0L);
                this.getCamelContext().getRegistry().bind("myPolicy", (Object)policy);
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().redeliveryPolicyRef("myPolicy"));
                this.from("direct:start").process((Processor)new MyProcessor());
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            ++counter;
            throw new Exception("Forced exception by unit test");
        }
    }
}

