/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultErrorHandlerOnPrepareTest
extends ContextTestSupport {
    @Test
    public void testDefaultErrorHandlerOnPrepare() {
        Exchange out = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        Assertions.assertNotNull((Object)out);
        Assertions.assertTrue((boolean)out.isFailed(), (String)"Should be failed");
        DefaultErrorHandlerOnPrepareTest.assertIsInstanceOf(IllegalArgumentException.class, out.getException());
        Assertions.assertEquals((Object)"Forced", (Object)out.getIn().getHeader("FailedBecause"));
        Assertions.assertEquals((Object)"foo", (Object)out.getIn().getHeader("FailedAtRoute"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().onPrepareFailure((Processor)new MyPrepareProcessor()));
                ((RouteDefinition)this.from("direct:start").routeId("foo").log("Incoming ${body}")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }

    public static class MyPrepareProcessor
    implements Processor {
        public void process(Exchange exchange) {
            Exception cause = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
            exchange.getIn().setHeader("FailedBecause", (Object)cause.getMessage());
            exchange.getIn().setHeader("FailedAtRoute", exchange.getProperty("CamelFailureRouteId", String.class));
        }
    }
}

