/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultErrorHandlerFailureRouteIdTest
extends ContextTestSupport {
    @Test
    public void testFailureRouteId() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.send("direct:foo", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        Assertions.assertNotNull((Object)out);
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertNotNull((Object)out.getException(IllegalArgumentException.class));
        Assertions.assertEquals((Object)"bar", (Object)out.getProperty("CamelFailureRouteId"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:foo").routeId("foo").to("mock:foo")).to("direct:bar")).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").to("mock:bar")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

