/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultErrorHandlerCatchThrowableTest
extends ContextTestSupport {
    @Test
    public void testDefaultErrorHandlerCatchThrowable() {
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Hello World", (Object)e.getExchange().getIn().getBody());
            NoSuchMethodError cause = DefaultErrorHandlerCatchThrowableTest.assertIsInstanceOf(NoSuchMethodError.class, e.getCause());
            Assertions.assertEquals((Object)"This is an Error not an Exception", (Object)cause.getMessage());
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                String exceptionString = "This is an Error not an Exception";
                this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) {
                        throw new NoSuchMethodError("This is an Error not an Exception");
                    }
                });
            }
        };
    }
}

